package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait ParallelDataFormat {
  def unwrap: software.amazon.awssdk.services.translate.model.ParallelDataFormat
}
object ParallelDataFormat {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.ParallelDataFormat
  ): zio.aws.translate.model.ParallelDataFormat = value match {
    case software.amazon.awssdk.services.translate.model.ParallelDataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.ParallelDataFormat.TSV =>
      val r = TSV
      r
    case software.amazon.awssdk.services.translate.model.ParallelDataFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.translate.model.ParallelDataFormat.TMX =>
      val r = TMX
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.translate.model.ParallelDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataFormat =
      software.amazon.awssdk.services.translate.model.ParallelDataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object TSV extends zio.aws.translate.model.ParallelDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataFormat =
      software.amazon.awssdk.services.translate.model.ParallelDataFormat.TSV
  }
  case object CSV extends zio.aws.translate.model.ParallelDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataFormat =
      software.amazon.awssdk.services.translate.model.ParallelDataFormat.CSV
  }
  case object TMX extends zio.aws.translate.model.ParallelDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataFormat =
      software.amazon.awssdk.services.translate.model.ParallelDataFormat.TMX
  }
}
