package zio.aws.translate.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.translate.model.primitives.{
  ParallelDataArn,
  UnboundedLengthString,
  Timestamp,
  Description,
  LanguageCodeString,
  ResourceName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ParallelDataProperties(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[ParallelDataArn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.translate.model.ParallelDataStatus] =
      Optional.Absent,
    sourceLanguageCode: Optional[LanguageCodeString] = Optional.Absent,
    targetLanguageCodes: Optional[Iterable[LanguageCodeString]] =
      Optional.Absent,
    parallelDataConfig: Optional[zio.aws.translate.model.ParallelDataConfig] =
      Optional.Absent,
    message: Optional[UnboundedLengthString] = Optional.Absent,
    importedDataSize: Optional[Long] = Optional.Absent,
    importedRecordCount: Optional[Long] = Optional.Absent,
    failedRecordCount: Optional[Long] = Optional.Absent,
    skippedRecordCount: Optional[Long] = Optional.Absent,
    encryptionKey: Optional[zio.aws.translate.model.EncryptionKey] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    latestUpdateAttemptStatus: Optional[
      zio.aws.translate.model.ParallelDataStatus
    ] = Optional.Absent,
    latestUpdateAttemptAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ParallelDataProperties = {
    import ParallelDataProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ParallelDataProperties
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => ParallelDataArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sourceLanguageCode.map(value =>
          LanguageCodeString.unwrap(value): java.lang.String
        )
      )(_.sourceLanguageCode)
      .optionallyWith(
        targetLanguageCodes.map(value =>
          value.map { item =>
            LanguageCodeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetLanguageCodes)
      .optionallyWith(parallelDataConfig.map(value => value.buildAwsValue()))(
        _.parallelDataConfig
      )
      .optionallyWith(
        message.map(value =>
          UnboundedLengthString.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(importedDataSize.map(value => value: java.lang.Long))(
        _.importedDataSize
      )
      .optionallyWith(importedRecordCount.map(value => value: java.lang.Long))(
        _.importedRecordCount
      )
      .optionallyWith(failedRecordCount.map(value => value: java.lang.Long))(
        _.failedRecordCount
      )
      .optionallyWith(skippedRecordCount.map(value => value: java.lang.Long))(
        _.skippedRecordCount
      )
      .optionallyWith(encryptionKey.map(value => value.buildAwsValue()))(
        _.encryptionKey
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(latestUpdateAttemptStatus.map(value => value.unwrap))(
        _.latestUpdateAttemptStatus
      )
      .optionallyWith(
        latestUpdateAttemptAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestUpdateAttemptAt)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.ParallelDataProperties.ReadOnly =
    zio.aws.translate.model.ParallelDataProperties.wrap(buildAwsValue())
}
object ParallelDataProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ParallelDataProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ParallelDataProperties =
      zio.aws.translate.model.ParallelDataProperties(
        name.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        status.map(value => value),
        sourceLanguageCode.map(value => value),
        targetLanguageCodes.map(value => value),
        parallelDataConfig.map(value => value.asEditable),
        message.map(value => value),
        importedDataSize.map(value => value),
        importedRecordCount.map(value => value),
        failedRecordCount.map(value => value),
        skippedRecordCount.map(value => value),
        encryptionKey.map(value => value.asEditable),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        latestUpdateAttemptStatus.map(value => value),
        latestUpdateAttemptAt.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[ParallelDataArn]
    def description: Optional[Description]
    def status: Optional[zio.aws.translate.model.ParallelDataStatus]
    def sourceLanguageCode: Optional[LanguageCodeString]
    def targetLanguageCodes: Optional[List[LanguageCodeString]]
    def parallelDataConfig
        : Optional[zio.aws.translate.model.ParallelDataConfig.ReadOnly]
    def message: Optional[UnboundedLengthString]
    def importedDataSize: Optional[Long]
    def importedRecordCount: Optional[Long]
    def failedRecordCount: Optional[Long]
    def skippedRecordCount: Optional[Long]
    def encryptionKey: Optional[zio.aws.translate.model.EncryptionKey.ReadOnly]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def latestUpdateAttemptStatus
        : Optional[zio.aws.translate.model.ParallelDataStatus]
    def latestUpdateAttemptAt: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, ParallelDataArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.translate.model.ParallelDataStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSourceLanguageCode: ZIO[Any, AwsError, LanguageCodeString] =
      AwsError.unwrapOptionField("sourceLanguageCode", sourceLanguageCode)
    def getTargetLanguageCodes: ZIO[Any, AwsError, List[LanguageCodeString]] =
      AwsError.unwrapOptionField("targetLanguageCodes", targetLanguageCodes)
    def getParallelDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.ParallelDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("parallelDataConfig", parallelDataConfig)
    def getMessage: ZIO[Any, AwsError, UnboundedLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getImportedDataSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("importedDataSize", importedDataSize)
    def getImportedRecordCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("importedRecordCount", importedRecordCount)
    def getFailedRecordCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("failedRecordCount", failedRecordCount)
    def getSkippedRecordCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("skippedRecordCount", skippedRecordCount)
    def getEncryptionKey
        : ZIO[Any, AwsError, zio.aws.translate.model.EncryptionKey.ReadOnly] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getLatestUpdateAttemptStatus
        : ZIO[Any, AwsError, zio.aws.translate.model.ParallelDataStatus] =
      AwsError.unwrapOptionField(
        "latestUpdateAttemptStatus",
        latestUpdateAttemptStatus
      )
    def getLatestUpdateAttemptAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestUpdateAttemptAt", latestUpdateAttemptAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ParallelDataProperties
  ) extends zio.aws.translate.model.ParallelDataProperties.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.translate.model.primitives.ResourceName(value))
    override val arn: Optional[ParallelDataArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.translate.model.primitives.ParallelDataArn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.translate.model.primitives.Description(value))
    override val status: Optional[zio.aws.translate.model.ParallelDataStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.translate.model.ParallelDataStatus.wrap(value))
    override val sourceLanguageCode: Optional[LanguageCodeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLanguageCode())
        .map(value =>
          zio.aws.translate.model.primitives.LanguageCodeString(value)
        )
    override val targetLanguageCodes: Optional[List[LanguageCodeString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLanguageCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.primitives.LanguageCodeString(item)
          }.toList
        )
    override val parallelDataConfig
        : Optional[zio.aws.translate.model.ParallelDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelDataConfig())
        .map(value => zio.aws.translate.model.ParallelDataConfig.wrap(value))
    override val message: Optional[UnboundedLengthString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.translate.model.primitives.UnboundedLengthString(value)
        )
    override val importedDataSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.importedDataSize())
      .map(value => value: Long)
    override val importedRecordCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.importedRecordCount())
      .map(value => value: Long)
    override val failedRecordCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.failedRecordCount())
      .map(value => value: Long)
    override val skippedRecordCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.skippedRecordCount())
      .map(value => value: Long)
    override val encryptionKey
        : Optional[zio.aws.translate.model.EncryptionKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKey())
        .map(value => zio.aws.translate.model.EncryptionKey.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.translate.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.translate.model.primitives.Timestamp(value))
    override val latestUpdateAttemptStatus
        : Optional[zio.aws.translate.model.ParallelDataStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestUpdateAttemptStatus())
        .map(value => zio.aws.translate.model.ParallelDataStatus.wrap(value))
    override val latestUpdateAttemptAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestUpdateAttemptAt())
        .map(value => zio.aws.translate.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ParallelDataProperties
  ): zio.aws.translate.model.ParallelDataProperties.ReadOnly = new Wrapper(impl)
}
