package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait ParallelDataStatus {
  def unwrap: software.amazon.awssdk.services.translate.model.ParallelDataStatus
}
object ParallelDataStatus {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.ParallelDataStatus
  ): zio.aws.translate.model.ParallelDataStatus = value match {
    case software.amazon.awssdk.services.translate.model.ParallelDataStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.ParallelDataStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.translate.model.ParallelDataStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.translate.model.ParallelDataStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.translate.model.ParallelDataStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.translate.model.ParallelDataStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.translate.model.ParallelDataStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataStatus =
      software.amazon.awssdk.services.translate.model.ParallelDataStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.translate.model.ParallelDataStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataStatus =
      software.amazon.awssdk.services.translate.model.ParallelDataStatus.CREATING
  }
  case object UPDATING extends zio.aws.translate.model.ParallelDataStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataStatus =
      software.amazon.awssdk.services.translate.model.ParallelDataStatus.UPDATING
  }
  case object ACTIVE extends zio.aws.translate.model.ParallelDataStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataStatus =
      software.amazon.awssdk.services.translate.model.ParallelDataStatus.ACTIVE
  }
  case object DELETING extends zio.aws.translate.model.ParallelDataStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataStatus =
      software.amazon.awssdk.services.translate.model.ParallelDataStatus.DELETING
  }
  case object FAILED extends zio.aws.translate.model.ParallelDataStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.ParallelDataStatus =
      software.amazon.awssdk.services.translate.model.ParallelDataStatus.FAILED
  }
}
