package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait Profanity {
  def unwrap: software.amazon.awssdk.services.translate.model.Profanity
}
object Profanity {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.Profanity
  ): zio.aws.translate.model.Profanity = value match {
    case software.amazon.awssdk.services.translate.model.Profanity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.Profanity.MASK =>
      val r = MASK
      r
  }
  case object unknownToSdkVersion extends zio.aws.translate.model.Profanity {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.Profanity =
      software.amazon.awssdk.services.translate.model.Profanity.UNKNOWN_TO_SDK_VERSION
  }
  case object MASK extends zio.aws.translate.model.Profanity {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.Profanity =
      software.amazon.awssdk.services.translate.model.Profanity.MASK
  }
}
