package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.{
  IamRoleArn,
  ClientTokenString,
  JobName,
  LanguageCodeString,
  ResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartTextTranslationJobRequest(
    jobName: Optional[JobName] = Optional.Absent,
    inputDataConfig: zio.aws.translate.model.InputDataConfig,
    outputDataConfig: zio.aws.translate.model.OutputDataConfig,
    dataAccessRoleArn: IamRoleArn,
    sourceLanguageCode: LanguageCodeString,
    targetLanguageCodes: Iterable[LanguageCodeString],
    terminologyNames: Optional[Iterable[ResourceName]] = Optional.Absent,
    parallelDataNames: Optional[Iterable[ResourceName]] = Optional.Absent,
    clientToken: ClientTokenString,
    settings: Optional[zio.aws.translate.model.TranslationSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest = {
    import StartTextTranslationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest
      .builder()
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .dataAccessRoleArn(IamRoleArn.unwrap(dataAccessRoleArn): java.lang.String)
      .sourceLanguageCode(
        LanguageCodeString.unwrap(sourceLanguageCode): java.lang.String
      )
      .targetLanguageCodes(targetLanguageCodes.map { item =>
        LanguageCodeString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        terminologyNames.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.terminologyNames)
      .optionallyWith(
        parallelDataNames.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parallelDataNames)
      .clientToken(ClientTokenString.unwrap(clientToken): java.lang.String)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly
      : zio.aws.translate.model.StartTextTranslationJobRequest.ReadOnly =
    zio.aws.translate.model.StartTextTranslationJobRequest.wrap(buildAwsValue())
}
object StartTextTranslationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.StartTextTranslationJobRequest =
      zio.aws.translate.model.StartTextTranslationJobRequest(
        jobName.map(value => value),
        inputDataConfig.asEditable,
        outputDataConfig.asEditable,
        dataAccessRoleArn,
        sourceLanguageCode,
        targetLanguageCodes,
        terminologyNames.map(value => value),
        parallelDataNames.map(value => value),
        clientToken,
        settings.map(value => value.asEditable)
      )
    def jobName: Optional[JobName]
    def inputDataConfig: zio.aws.translate.model.InputDataConfig.ReadOnly
    def outputDataConfig: zio.aws.translate.model.OutputDataConfig.ReadOnly
    def dataAccessRoleArn: IamRoleArn
    def sourceLanguageCode: LanguageCodeString
    def targetLanguageCodes: List[LanguageCodeString]
    def terminologyNames: Optional[List[ResourceName]]
    def parallelDataNames: Optional[List[ResourceName]]
    def clientToken: ClientTokenString
    def settings: Optional[zio.aws.translate.model.TranslationSettings.ReadOnly]
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getInputDataConfig
        : ZIO[Any, Nothing, zio.aws.translate.model.InputDataConfig.ReadOnly] =
      ZIO.succeed(inputDataConfig)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.translate.model.OutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getDataAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
    def getSourceLanguageCode: ZIO[Any, Nothing, LanguageCodeString] =
      ZIO.succeed(sourceLanguageCode)
    def getTargetLanguageCodes: ZIO[Any, Nothing, List[LanguageCodeString]] =
      ZIO.succeed(targetLanguageCodes)
    def getTerminologyNames: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("terminologyNames", terminologyNames)
    def getParallelDataNames: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("parallelDataNames", parallelDataNames)
    def getClientToken: ZIO[Any, Nothing, ClientTokenString] =
      ZIO.succeed(clientToken)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TranslationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest
  ) extends zio.aws.translate.model.StartTextTranslationJobRequest.ReadOnly {
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.translate.model.primitives.JobName(value))
    override val inputDataConfig
        : zio.aws.translate.model.InputDataConfig.ReadOnly =
      zio.aws.translate.model.InputDataConfig.wrap(impl.inputDataConfig())
    override val outputDataConfig
        : zio.aws.translate.model.OutputDataConfig.ReadOnly =
      zio.aws.translate.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val dataAccessRoleArn: IamRoleArn =
      zio.aws.translate.model.primitives.IamRoleArn(impl.dataAccessRoleArn())
    override val sourceLanguageCode: LanguageCodeString =
      zio.aws.translate.model.primitives
        .LanguageCodeString(impl.sourceLanguageCode())
    override val targetLanguageCodes: List[LanguageCodeString] = impl
      .targetLanguageCodes()
      .asScala
      .map { item =>
        zio.aws.translate.model.primitives.LanguageCodeString(item)
      }
      .toList
    override val terminologyNames: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminologyNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.primitives.ResourceName(item)
          }.toList
        )
    override val parallelDataNames: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelDataNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.primitives.ResourceName(item)
          }.toList
        )
    override val clientToken: ClientTokenString =
      zio.aws.translate.model.primitives.ClientTokenString(impl.clientToken())
    override val settings
        : Optional[zio.aws.translate.model.TranslationSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value => zio.aws.translate.model.TranslationSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest
  ): zio.aws.translate.model.StartTextTranslationJobRequest.ReadOnly =
    new Wrapper(impl)
}
