package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.JobId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartTextTranslationJobResponse(
    jobId: Optional[JobId] = Optional.Absent,
    jobStatus: Optional[zio.aws.translate.model.JobStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse = {
    import StartTextTranslationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.translate.model.StartTextTranslationJobResponse.ReadOnly =
    zio.aws.translate.model.StartTextTranslationJobResponse
      .wrap(buildAwsValue())
}
object StartTextTranslationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.StartTextTranslationJobResponse =
      zio.aws.translate.model.StartTextTranslationJobResponse(
        jobId.map(value => value),
        jobStatus.map(value => value)
      )
    def jobId: Optional[JobId]
    def jobStatus: Optional[zio.aws.translate.model.JobStatus]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.translate.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse
  ) extends zio.aws.translate.model.StartTextTranslationJobResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.translate.model.primitives.JobId(value))
    override val jobStatus: Optional[zio.aws.translate.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.translate.model.JobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse
  ): zio.aws.translate.model.StartTextTranslationJobResponse.ReadOnly =
    new Wrapper(impl)
}
