package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopTextTranslationJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest = {
    import StopTextTranslationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.translate.model.StopTextTranslationJobRequest.ReadOnly =
    zio.aws.translate.model.StopTextTranslationJobRequest.wrap(buildAwsValue())
}
object StopTextTranslationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.StopTextTranslationJobRequest =
      zio.aws.translate.model.StopTextTranslationJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest
  ) extends zio.aws.translate.model.StopTextTranslationJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.translate.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest
  ): zio.aws.translate.model.StopTextTranslationJobRequest.ReadOnly =
    new Wrapper(impl)
}
