package zio.aws.translate.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Term(
    sourceText: Optional[String] = Optional.Absent,
    targetText: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.translate.model.Term = {
    import Term.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.Term
      .builder()
      .optionallyWith(sourceText.map(value => value: java.lang.String))(
        _.sourceText
      )
      .optionallyWith(targetText.map(value => value: java.lang.String))(
        _.targetText
      )
      .build()
  }
  def asReadOnly: zio.aws.translate.model.Term.ReadOnly =
    zio.aws.translate.model.Term.wrap(buildAwsValue())
}
object Term {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.translate.model.Term] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.Term = zio.aws.translate.model
      .Term(sourceText.map(value => value), targetText.map(value => value))
    def sourceText: Optional[String]
    def targetText: Optional[String]
    def getSourceText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceText", sourceText)
    def getTargetText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetText", targetText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.Term
  ) extends zio.aws.translate.model.Term.ReadOnly {
    override val sourceText: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceText())
      .map(value => value: String)
    override val targetText: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetText())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.Term
  ): zio.aws.translate.model.Term.ReadOnly = new Wrapper(impl)
}
