package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.TerminologyFile
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TerminologyData(
    file: TerminologyFile,
    format: zio.aws.translate.model.TerminologyDataFormat,
    directionality: Optional[zio.aws.translate.model.Directionality] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.TerminologyData = {
    import TerminologyData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.TerminologyData
      .builder()
      .file(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(file.toArray[Byte])
      )
      .format(format.unwrap)
      .optionallyWith(directionality.map(value => value.unwrap))(
        _.directionality
      )
      .build()
  }
  def asReadOnly: zio.aws.translate.model.TerminologyData.ReadOnly =
    zio.aws.translate.model.TerminologyData.wrap(buildAwsValue())
}
object TerminologyData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.TerminologyData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.TerminologyData =
      zio.aws.translate.model
        .TerminologyData(file, format, directionality.map(value => value))
    def file: TerminologyFile
    def format: zio.aws.translate.model.TerminologyDataFormat
    def directionality: Optional[zio.aws.translate.model.Directionality]
    def getFile: ZIO[Any, Nothing, TerminologyFile] = ZIO.succeed(file)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.translate.model.TerminologyDataFormat] =
      ZIO.succeed(format)
    def getDirectionality
        : ZIO[Any, AwsError, zio.aws.translate.model.Directionality] =
      AwsError.unwrapOptionField("directionality", directionality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.TerminologyData
  ) extends zio.aws.translate.model.TerminologyData.ReadOnly {
    override val file: TerminologyFile = zio.aws.translate.model.primitives
      .TerminologyFile(zio.Chunk.fromArray(impl.file().asByteArrayUnsafe()))
    override val format: zio.aws.translate.model.TerminologyDataFormat =
      zio.aws.translate.model.TerminologyDataFormat.wrap(impl.format())
    override val directionality
        : Optional[zio.aws.translate.model.Directionality] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directionality())
        .map(value => zio.aws.translate.model.Directionality.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.TerminologyData
  ): zio.aws.translate.model.TerminologyData.ReadOnly = new Wrapper(impl)
}
