package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait TerminologyDataFormat {
  def unwrap
      : software.amazon.awssdk.services.translate.model.TerminologyDataFormat
}
object TerminologyDataFormat {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.TerminologyDataFormat
  ): zio.aws.translate.model.TerminologyDataFormat = value match {
    case software.amazon.awssdk.services.translate.model.TerminologyDataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.TerminologyDataFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.translate.model.TerminologyDataFormat.TMX =>
      val r = TMX
      r
    case software.amazon.awssdk.services.translate.model.TerminologyDataFormat.TSV =>
      val r = TSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.translate.model.TerminologyDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.TerminologyDataFormat =
      software.amazon.awssdk.services.translate.model.TerminologyDataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.translate.model.TerminologyDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.TerminologyDataFormat =
      software.amazon.awssdk.services.translate.model.TerminologyDataFormat.CSV
  }
  case object TMX extends zio.aws.translate.model.TerminologyDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.TerminologyDataFormat =
      software.amazon.awssdk.services.translate.model.TerminologyDataFormat.TMX
  }
  case object TSV extends zio.aws.translate.model.TerminologyDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.TerminologyDataFormat =
      software.amazon.awssdk.services.translate.model.TerminologyDataFormat.TSV
  }
}
