package zio.aws.translate.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TerminologyDataLocation(
    repositoryType: String,
    location: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.TerminologyDataLocation = {
    import TerminologyDataLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.TerminologyDataLocation
      .builder()
      .repositoryType(repositoryType: java.lang.String)
      .location(location: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.TerminologyDataLocation.ReadOnly =
    zio.aws.translate.model.TerminologyDataLocation.wrap(buildAwsValue())
}
object TerminologyDataLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.TerminologyDataLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.TerminologyDataLocation =
      zio.aws.translate.model.TerminologyDataLocation(repositoryType, location)
    def repositoryType: String
    def location: String
    def getRepositoryType: ZIO[Any, Nothing, String] =
      ZIO.succeed(repositoryType)
    def getLocation: ZIO[Any, Nothing, String] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.TerminologyDataLocation
  ) extends zio.aws.translate.model.TerminologyDataLocation.ReadOnly {
    override val repositoryType: String = impl.repositoryType(): String
    override val location: String = impl.location(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.TerminologyDataLocation
  ): zio.aws.translate.model.TerminologyDataLocation.ReadOnly = new Wrapper(
    impl
  )
}
