package zio.aws.translate.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.translate.model.primitives.{
  UnboundedLengthString,
  Timestamp,
  Integer,
  Description,
  TerminologyArn,
  LanguageCodeString,
  ResourceName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TerminologyProperties(
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    arn: Optional[TerminologyArn] = Optional.Absent,
    sourceLanguageCode: Optional[LanguageCodeString] = Optional.Absent,
    targetLanguageCodes: Optional[Iterable[LanguageCodeString]] =
      Optional.Absent,
    encryptionKey: Optional[zio.aws.translate.model.EncryptionKey] =
      Optional.Absent,
    sizeBytes: Optional[Integer] = Optional.Absent,
    termCount: Optional[Integer] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    directionality: Optional[zio.aws.translate.model.Directionality] =
      Optional.Absent,
    message: Optional[UnboundedLengthString] = Optional.Absent,
    skippedTermCount: Optional[Integer] = Optional.Absent,
    format: Optional[zio.aws.translate.model.TerminologyDataFormat] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.TerminologyProperties = {
    import TerminologyProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.TerminologyProperties
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        arn.map(value => TerminologyArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        sourceLanguageCode.map(value =>
          LanguageCodeString.unwrap(value): java.lang.String
        )
      )(_.sourceLanguageCode)
      .optionallyWith(
        targetLanguageCodes.map(value =>
          value.map { item =>
            LanguageCodeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetLanguageCodes)
      .optionallyWith(encryptionKey.map(value => value.buildAwsValue()))(
        _.encryptionKey
      )
      .optionallyWith(sizeBytes.map(value => value: java.lang.Integer))(
        _.sizeBytes
      )
      .optionallyWith(termCount.map(value => value: java.lang.Integer))(
        _.termCount
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(directionality.map(value => value.unwrap))(
        _.directionality
      )
      .optionallyWith(
        message.map(value =>
          UnboundedLengthString.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(skippedTermCount.map(value => value: java.lang.Integer))(
        _.skippedTermCount
      )
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.TerminologyProperties.ReadOnly =
    zio.aws.translate.model.TerminologyProperties.wrap(buildAwsValue())
}
object TerminologyProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.TerminologyProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.TerminologyProperties =
      zio.aws.translate.model.TerminologyProperties(
        name.map(value => value),
        description.map(value => value),
        arn.map(value => value),
        sourceLanguageCode.map(value => value),
        targetLanguageCodes.map(value => value),
        encryptionKey.map(value => value.asEditable),
        sizeBytes.map(value => value),
        termCount.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        directionality.map(value => value),
        message.map(value => value),
        skippedTermCount.map(value => value),
        format.map(value => value)
      )
    def name: Optional[ResourceName]
    def description: Optional[Description]
    def arn: Optional[TerminologyArn]
    def sourceLanguageCode: Optional[LanguageCodeString]
    def targetLanguageCodes: Optional[List[LanguageCodeString]]
    def encryptionKey: Optional[zio.aws.translate.model.EncryptionKey.ReadOnly]
    def sizeBytes: Optional[Integer]
    def termCount: Optional[Integer]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def directionality: Optional[zio.aws.translate.model.Directionality]
    def message: Optional[UnboundedLengthString]
    def skippedTermCount: Optional[Integer]
    def format: Optional[zio.aws.translate.model.TerminologyDataFormat]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, TerminologyArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getSourceLanguageCode: ZIO[Any, AwsError, LanguageCodeString] =
      AwsError.unwrapOptionField("sourceLanguageCode", sourceLanguageCode)
    def getTargetLanguageCodes: ZIO[Any, AwsError, List[LanguageCodeString]] =
      AwsError.unwrapOptionField("targetLanguageCodes", targetLanguageCodes)
    def getEncryptionKey
        : ZIO[Any, AwsError, zio.aws.translate.model.EncryptionKey.ReadOnly] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getSizeBytes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeBytes", sizeBytes)
    def getTermCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("termCount", termCount)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getDirectionality
        : ZIO[Any, AwsError, zio.aws.translate.model.Directionality] =
      AwsError.unwrapOptionField("directionality", directionality)
    def getMessage: ZIO[Any, AwsError, UnboundedLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSkippedTermCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("skippedTermCount", skippedTermCount)
    def getFormat
        : ZIO[Any, AwsError, zio.aws.translate.model.TerminologyDataFormat] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.TerminologyProperties
  ) extends zio.aws.translate.model.TerminologyProperties.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.translate.model.primitives.ResourceName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.translate.model.primitives.Description(value))
    override val arn: Optional[TerminologyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.translate.model.primitives.TerminologyArn(value))
    override val sourceLanguageCode: Optional[LanguageCodeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLanguageCode())
        .map(value =>
          zio.aws.translate.model.primitives.LanguageCodeString(value)
        )
    override val targetLanguageCodes: Optional[List[LanguageCodeString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLanguageCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.primitives.LanguageCodeString(item)
          }.toList
        )
    override val encryptionKey
        : Optional[zio.aws.translate.model.EncryptionKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKey())
        .map(value => zio.aws.translate.model.EncryptionKey.wrap(value))
    override val sizeBytes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeBytes())
      .map(value => value: Integer)
    override val termCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.termCount())
      .map(value => value: Integer)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.translate.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.translate.model.primitives.Timestamp(value))
    override val directionality
        : Optional[zio.aws.translate.model.Directionality] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directionality())
        .map(value => zio.aws.translate.model.Directionality.wrap(value))
    override val message: Optional[UnboundedLengthString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.translate.model.primitives.UnboundedLengthString(value)
        )
    override val skippedTermCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.skippedTermCount())
      .map(value => value: Integer)
    override val format
        : Optional[zio.aws.translate.model.TerminologyDataFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.translate.model.TerminologyDataFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.TerminologyProperties
  ): zio.aws.translate.model.TerminologyProperties.ReadOnly = new Wrapper(impl)
}
