package zio.aws.translate.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.translate.model.primitives.{Timestamp, JobName}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TextTranslationJobFilter(
    jobName: Optional[JobName] = Optional.Absent,
    jobStatus: Optional[zio.aws.translate.model.JobStatus] = Optional.Absent,
    submittedBeforeTime: Optional[Timestamp] = Optional.Absent,
    submittedAfterTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.TextTranslationJobFilter = {
    import TextTranslationJobFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.TextTranslationJobFilter
      .builder()
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        submittedBeforeTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submittedBeforeTime)
      .optionallyWith(
        submittedAfterTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submittedAfterTime)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.TextTranslationJobFilter.ReadOnly =
    zio.aws.translate.model.TextTranslationJobFilter.wrap(buildAwsValue())
}
object TextTranslationJobFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.TextTranslationJobFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.TextTranslationJobFilter =
      zio.aws.translate.model.TextTranslationJobFilter(
        jobName.map(value => value),
        jobStatus.map(value => value),
        submittedBeforeTime.map(value => value),
        submittedAfterTime.map(value => value)
      )
    def jobName: Optional[JobName]
    def jobStatus: Optional[zio.aws.translate.model.JobStatus]
    def submittedBeforeTime: Optional[Timestamp]
    def submittedAfterTime: Optional[Timestamp]
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.translate.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getSubmittedBeforeTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submittedBeforeTime", submittedBeforeTime)
    def getSubmittedAfterTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submittedAfterTime", submittedAfterTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.TextTranslationJobFilter
  ) extends zio.aws.translate.model.TextTranslationJobFilter.ReadOnly {
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.translate.model.primitives.JobName(value))
    override val jobStatus: Optional[zio.aws.translate.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.translate.model.JobStatus.wrap(value))
    override val submittedBeforeTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.submittedBeforeTime())
        .map(value => zio.aws.translate.model.primitives.Timestamp(value))
    override val submittedAfterTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submittedAfterTime())
      .map(value => zio.aws.translate.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.TextTranslationJobFilter
  ): zio.aws.translate.model.TextTranslationJobFilter.ReadOnly = new Wrapper(
    impl
  )
}
