package zio.aws.translate.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.translate.model.primitives.{
  IamRoleArn,
  UnboundedLengthString,
  Timestamp,
  JobName,
  JobId,
  LanguageCodeString,
  ResourceName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TextTranslationJobProperties(
    jobId: Optional[JobId] = Optional.Absent,
    jobName: Optional[JobName] = Optional.Absent,
    jobStatus: Optional[zio.aws.translate.model.JobStatus] = Optional.Absent,
    jobDetails: Optional[zio.aws.translate.model.JobDetails] = Optional.Absent,
    sourceLanguageCode: Optional[LanguageCodeString] = Optional.Absent,
    targetLanguageCodes: Optional[Iterable[LanguageCodeString]] =
      Optional.Absent,
    terminologyNames: Optional[Iterable[ResourceName]] = Optional.Absent,
    parallelDataNames: Optional[Iterable[ResourceName]] = Optional.Absent,
    message: Optional[UnboundedLengthString] = Optional.Absent,
    submittedTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    inputDataConfig: Optional[zio.aws.translate.model.InputDataConfig] =
      Optional.Absent,
    outputDataConfig: Optional[zio.aws.translate.model.OutputDataConfig] =
      Optional.Absent,
    dataAccessRoleArn: Optional[IamRoleArn] = Optional.Absent,
    settings: Optional[zio.aws.translate.model.TranslationSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.TextTranslationJobProperties = {
    import TextTranslationJobProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.TextTranslationJobProperties
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .optionallyWith(
        sourceLanguageCode.map(value =>
          LanguageCodeString.unwrap(value): java.lang.String
        )
      )(_.sourceLanguageCode)
      .optionallyWith(
        targetLanguageCodes.map(value =>
          value.map { item =>
            LanguageCodeString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetLanguageCodes)
      .optionallyWith(
        terminologyNames.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.terminologyNames)
      .optionallyWith(
        parallelDataNames.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parallelDataNames)
      .optionallyWith(
        message.map(value =>
          UnboundedLengthString.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(
        submittedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submittedTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly
      : zio.aws.translate.model.TextTranslationJobProperties.ReadOnly =
    zio.aws.translate.model.TextTranslationJobProperties.wrap(buildAwsValue())
}
object TextTranslationJobProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.TextTranslationJobProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.TextTranslationJobProperties =
      zio.aws.translate.model.TextTranslationJobProperties(
        jobId.map(value => value),
        jobName.map(value => value),
        jobStatus.map(value => value),
        jobDetails.map(value => value.asEditable),
        sourceLanguageCode.map(value => value),
        targetLanguageCodes.map(value => value),
        terminologyNames.map(value => value),
        parallelDataNames.map(value => value),
        message.map(value => value),
        submittedTime.map(value => value),
        endTime.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        outputDataConfig.map(value => value.asEditable),
        dataAccessRoleArn.map(value => value),
        settings.map(value => value.asEditable)
      )
    def jobId: Optional[JobId]
    def jobName: Optional[JobName]
    def jobStatus: Optional[zio.aws.translate.model.JobStatus]
    def jobDetails: Optional[zio.aws.translate.model.JobDetails.ReadOnly]
    def sourceLanguageCode: Optional[LanguageCodeString]
    def targetLanguageCodes: Optional[List[LanguageCodeString]]
    def terminologyNames: Optional[List[ResourceName]]
    def parallelDataNames: Optional[List[ResourceName]]
    def message: Optional[UnboundedLengthString]
    def submittedTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def inputDataConfig
        : Optional[zio.aws.translate.model.InputDataConfig.ReadOnly]
    def outputDataConfig
        : Optional[zio.aws.translate.model.OutputDataConfig.ReadOnly]
    def dataAccessRoleArn: Optional[IamRoleArn]
    def settings: Optional[zio.aws.translate.model.TranslationSettings.ReadOnly]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.translate.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getJobDetails
        : ZIO[Any, AwsError, zio.aws.translate.model.JobDetails.ReadOnly] =
      AwsError.unwrapOptionField("jobDetails", jobDetails)
    def getSourceLanguageCode: ZIO[Any, AwsError, LanguageCodeString] =
      AwsError.unwrapOptionField("sourceLanguageCode", sourceLanguageCode)
    def getTargetLanguageCodes: ZIO[Any, AwsError, List[LanguageCodeString]] =
      AwsError.unwrapOptionField("targetLanguageCodes", targetLanguageCodes)
    def getTerminologyNames: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("terminologyNames", terminologyNames)
    def getParallelDataNames: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("parallelDataNames", parallelDataNames)
    def getMessage: ZIO[Any, AwsError, UnboundedLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSubmittedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submittedTime", submittedTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getInputDataConfig
        : ZIO[Any, AwsError, zio.aws.translate.model.InputDataConfig.ReadOnly] =
      AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.OutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TranslationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.TextTranslationJobProperties
  ) extends zio.aws.translate.model.TextTranslationJobProperties.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.translate.model.primitives.JobId(value))
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.translate.model.primitives.JobName(value))
    override val jobStatus: Optional[zio.aws.translate.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.translate.model.JobStatus.wrap(value))
    override val jobDetails
        : Optional[zio.aws.translate.model.JobDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDetails())
        .map(value => zio.aws.translate.model.JobDetails.wrap(value))
    override val sourceLanguageCode: Optional[LanguageCodeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLanguageCode())
        .map(value =>
          zio.aws.translate.model.primitives.LanguageCodeString(value)
        )
    override val targetLanguageCodes: Optional[List[LanguageCodeString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLanguageCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.primitives.LanguageCodeString(item)
          }.toList
        )
    override val terminologyNames: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminologyNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.primitives.ResourceName(item)
          }.toList
        )
    override val parallelDataNames: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelDataNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.primitives.ResourceName(item)
          }.toList
        )
    override val message: Optional[UnboundedLengthString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.translate.model.primitives.UnboundedLengthString(value)
        )
    override val submittedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submittedTime())
      .map(value => zio.aws.translate.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.translate.model.primitives.Timestamp(value))
    override val inputDataConfig
        : Optional[zio.aws.translate.model.InputDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputDataConfig())
        .map(value => zio.aws.translate.model.InputDataConfig.wrap(value))
    override val outputDataConfig
        : Optional[zio.aws.translate.model.OutputDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputDataConfig())
        .map(value => zio.aws.translate.model.OutputDataConfig.wrap(value))
    override val dataAccessRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAccessRoleArn())
      .map(value => zio.aws.translate.model.primitives.IamRoleArn(value))
    override val settings
        : Optional[zio.aws.translate.model.TranslationSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value => zio.aws.translate.model.TranslationSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.TextTranslationJobProperties
  ): zio.aws.translate.model.TextTranslationJobProperties.ReadOnly =
    new Wrapper(impl)
}
