package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.{
  LanguageCodeString,
  ResourceName,
  BoundedLengthString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TranslateTextRequest(
    text: BoundedLengthString,
    terminologyNames: Optional[Iterable[ResourceName]] = Optional.Absent,
    sourceLanguageCode: LanguageCodeString,
    targetLanguageCode: LanguageCodeString,
    settings: Optional[zio.aws.translate.model.TranslationSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.TranslateTextRequest = {
    import TranslateTextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.TranslateTextRequest
      .builder()
      .text(BoundedLengthString.unwrap(text): java.lang.String)
      .optionallyWith(
        terminologyNames.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.terminologyNames)
      .sourceLanguageCode(
        LanguageCodeString.unwrap(sourceLanguageCode): java.lang.String
      )
      .targetLanguageCode(
        LanguageCodeString.unwrap(targetLanguageCode): java.lang.String
      )
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.TranslateTextRequest.ReadOnly =
    zio.aws.translate.model.TranslateTextRequest.wrap(buildAwsValue())
}
object TranslateTextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.TranslateTextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.TranslateTextRequest =
      zio.aws.translate.model.TranslateTextRequest(
        text,
        terminologyNames.map(value => value),
        sourceLanguageCode,
        targetLanguageCode,
        settings.map(value => value.asEditable)
      )
    def text: BoundedLengthString
    def terminologyNames: Optional[List[ResourceName]]
    def sourceLanguageCode: LanguageCodeString
    def targetLanguageCode: LanguageCodeString
    def settings: Optional[zio.aws.translate.model.TranslationSettings.ReadOnly]
    def getText: ZIO[Any, Nothing, BoundedLengthString] = ZIO.succeed(text)
    def getTerminologyNames: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("terminologyNames", terminologyNames)
    def getSourceLanguageCode: ZIO[Any, Nothing, LanguageCodeString] =
      ZIO.succeed(sourceLanguageCode)
    def getTargetLanguageCode: ZIO[Any, Nothing, LanguageCodeString] =
      ZIO.succeed(targetLanguageCode)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TranslationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.TranslateTextRequest
  ) extends zio.aws.translate.model.TranslateTextRequest.ReadOnly {
    override val text: BoundedLengthString =
      zio.aws.translate.model.primitives.BoundedLengthString(impl.text())
    override val terminologyNames: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminologyNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.primitives.ResourceName(item)
          }.toList
        )
    override val sourceLanguageCode: LanguageCodeString =
      zio.aws.translate.model.primitives
        .LanguageCodeString(impl.sourceLanguageCode())
    override val targetLanguageCode: LanguageCodeString =
      zio.aws.translate.model.primitives
        .LanguageCodeString(impl.targetLanguageCode())
    override val settings
        : Optional[zio.aws.translate.model.TranslationSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value => zio.aws.translate.model.TranslationSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.TranslateTextRequest
  ): zio.aws.translate.model.TranslateTextRequest.ReadOnly = new Wrapper(impl)
}
