package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.LanguageCodeString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TranslateTextResponse(
    translatedText: String,
    sourceLanguageCode: LanguageCodeString,
    targetLanguageCode: LanguageCodeString,
    appliedTerminologies: Optional[
      Iterable[zio.aws.translate.model.AppliedTerminology]
    ] = Optional.Absent,
    appliedSettings: Optional[zio.aws.translate.model.TranslationSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.TranslateTextResponse = {
    import TranslateTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.TranslateTextResponse
      .builder()
      .translatedText(translatedText: java.lang.String)
      .sourceLanguageCode(
        LanguageCodeString.unwrap(sourceLanguageCode): java.lang.String
      )
      .targetLanguageCode(
        LanguageCodeString.unwrap(targetLanguageCode): java.lang.String
      )
      .optionallyWith(
        appliedTerminologies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appliedTerminologies)
      .optionallyWith(appliedSettings.map(value => value.buildAwsValue()))(
        _.appliedSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.translate.model.TranslateTextResponse.ReadOnly =
    zio.aws.translate.model.TranslateTextResponse.wrap(buildAwsValue())
}
object TranslateTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.TranslateTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.TranslateTextResponse =
      zio.aws.translate.model.TranslateTextResponse(
        translatedText,
        sourceLanguageCode,
        targetLanguageCode,
        appliedTerminologies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        appliedSettings.map(value => value.asEditable)
      )
    def translatedText: String
    def sourceLanguageCode: LanguageCodeString
    def targetLanguageCode: LanguageCodeString
    def appliedTerminologies
        : Optional[List[zio.aws.translate.model.AppliedTerminology.ReadOnly]]
    def appliedSettings
        : Optional[zio.aws.translate.model.TranslationSettings.ReadOnly]
    def getTranslatedText: ZIO[Any, Nothing, String] =
      ZIO.succeed(translatedText)
    def getSourceLanguageCode: ZIO[Any, Nothing, LanguageCodeString] =
      ZIO.succeed(sourceLanguageCode)
    def getTargetLanguageCode: ZIO[Any, Nothing, LanguageCodeString] =
      ZIO.succeed(targetLanguageCode)
    def getAppliedTerminologies: ZIO[Any, AwsError, List[
      zio.aws.translate.model.AppliedTerminology.ReadOnly
    ]] =
      AwsError.unwrapOptionField("appliedTerminologies", appliedTerminologies)
    def getAppliedSettings: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TranslationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("appliedSettings", appliedSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.TranslateTextResponse
  ) extends zio.aws.translate.model.TranslateTextResponse.ReadOnly {
    override val translatedText: String = impl.translatedText(): String
    override val sourceLanguageCode: LanguageCodeString =
      zio.aws.translate.model.primitives
        .LanguageCodeString(impl.sourceLanguageCode())
    override val targetLanguageCode: LanguageCodeString =
      zio.aws.translate.model.primitives
        .LanguageCodeString(impl.targetLanguageCode())
    override val appliedTerminologies
        : Optional[List[zio.aws.translate.model.AppliedTerminology.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appliedTerminologies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.AppliedTerminology.wrap(item)
          }.toList
        )
    override val appliedSettings
        : Optional[zio.aws.translate.model.TranslationSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appliedSettings())
        .map(value => zio.aws.translate.model.TranslationSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.TranslateTextResponse
  ): zio.aws.translate.model.TranslateTextResponse.ReadOnly = new Wrapper(impl)
}
