package zio.aws.translate.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TranslationSettings(
    formality: Optional[zio.aws.translate.model.Formality] = Optional.Absent,
    profanity: Optional[zio.aws.translate.model.Profanity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.TranslationSettings = {
    import TranslationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.TranslationSettings
      .builder()
      .optionallyWith(formality.map(value => value.unwrap))(_.formality)
      .optionallyWith(profanity.map(value => value.unwrap))(_.profanity)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.TranslationSettings.ReadOnly =
    zio.aws.translate.model.TranslationSettings.wrap(buildAwsValue())
}
object TranslationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.TranslationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.TranslationSettings =
      zio.aws.translate.model.TranslationSettings(
        formality.map(value => value),
        profanity.map(value => value)
      )
    def formality: Optional[zio.aws.translate.model.Formality]
    def profanity: Optional[zio.aws.translate.model.Profanity]
    def getFormality: ZIO[Any, AwsError, zio.aws.translate.model.Formality] =
      AwsError.unwrapOptionField("formality", formality)
    def getProfanity: ZIO[Any, AwsError, zio.aws.translate.model.Profanity] =
      AwsError.unwrapOptionField("profanity", profanity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.TranslationSettings
  ) extends zio.aws.translate.model.TranslationSettings.ReadOnly {
    override val formality: Optional[zio.aws.translate.model.Formality] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formality())
        .map(value => zio.aws.translate.model.Formality.wrap(value))
    override val profanity: Optional[zio.aws.translate.model.Profanity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profanity())
        .map(value => zio.aws.translate.model.Profanity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.TranslationSettings
  ): zio.aws.translate.model.TranslationSettings.ReadOnly = new Wrapper(impl)
}
