package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.{
  ClientTokenString,
  Description,
  ResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateParallelDataRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    parallelDataConfig: zio.aws.translate.model.ParallelDataConfig,
    clientToken: ClientTokenString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest = {
    import UpdateParallelDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .parallelDataConfig(parallelDataConfig.buildAwsValue())
      .clientToken(ClientTokenString.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.UpdateParallelDataRequest.ReadOnly =
    zio.aws.translate.model.UpdateParallelDataRequest.wrap(buildAwsValue())
}
object UpdateParallelDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.UpdateParallelDataRequest =
      zio.aws.translate.model.UpdateParallelDataRequest(
        name,
        description.map(value => value),
        parallelDataConfig.asEditable,
        clientToken
      )
    def name: ResourceName
    def description: Optional[Description]
    def parallelDataConfig: zio.aws.translate.model.ParallelDataConfig.ReadOnly
    def clientToken: ClientTokenString
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParallelDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.translate.model.ParallelDataConfig.ReadOnly
    ] = ZIO.succeed(parallelDataConfig)
    def getClientToken: ZIO[Any, Nothing, ClientTokenString] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest
  ) extends zio.aws.translate.model.UpdateParallelDataRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.translate.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.translate.model.primitives.Description(value))
    override val parallelDataConfig
        : zio.aws.translate.model.ParallelDataConfig.ReadOnly =
      zio.aws.translate.model.ParallelDataConfig.wrap(impl.parallelDataConfig())
    override val clientToken: ClientTokenString =
      zio.aws.translate.model.primitives.ClientTokenString(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest
  ): zio.aws.translate.model.UpdateParallelDataRequest.ReadOnly = new Wrapper(
    impl
  )
}
