package zio.aws.translate.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.translate.model.primitives.{Timestamp, ResourceName}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateParallelDataResponse(
    name: Optional[ResourceName] = Optional.Absent,
    status: Optional[zio.aws.translate.model.ParallelDataStatus] =
      Optional.Absent,
    latestUpdateAttemptStatus: Optional[
      zio.aws.translate.model.ParallelDataStatus
    ] = Optional.Absent,
    latestUpdateAttemptAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.UpdateParallelDataResponse = {
    import UpdateParallelDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.UpdateParallelDataResponse
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(latestUpdateAttemptStatus.map(value => value.unwrap))(
        _.latestUpdateAttemptStatus
      )
      .optionallyWith(
        latestUpdateAttemptAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestUpdateAttemptAt)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.UpdateParallelDataResponse.ReadOnly =
    zio.aws.translate.model.UpdateParallelDataResponse.wrap(buildAwsValue())
}
object UpdateParallelDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.UpdateParallelDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.UpdateParallelDataResponse =
      zio.aws.translate.model.UpdateParallelDataResponse(
        name.map(value => value),
        status.map(value => value),
        latestUpdateAttemptStatus.map(value => value),
        latestUpdateAttemptAt.map(value => value)
      )
    def name: Optional[ResourceName]
    def status: Optional[zio.aws.translate.model.ParallelDataStatus]
    def latestUpdateAttemptStatus
        : Optional[zio.aws.translate.model.ParallelDataStatus]
    def latestUpdateAttemptAt: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.translate.model.ParallelDataStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLatestUpdateAttemptStatus
        : ZIO[Any, AwsError, zio.aws.translate.model.ParallelDataStatus] =
      AwsError.unwrapOptionField(
        "latestUpdateAttemptStatus",
        latestUpdateAttemptStatus
      )
    def getLatestUpdateAttemptAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestUpdateAttemptAt", latestUpdateAttemptAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.UpdateParallelDataResponse
  ) extends zio.aws.translate.model.UpdateParallelDataResponse.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.translate.model.primitives.ResourceName(value))
    override val status: Optional[zio.aws.translate.model.ParallelDataStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.translate.model.ParallelDataStatus.wrap(value))
    override val latestUpdateAttemptStatus
        : Optional[zio.aws.translate.model.ParallelDataStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestUpdateAttemptStatus())
        .map(value => zio.aws.translate.model.ParallelDataStatus.wrap(value))
    override val latestUpdateAttemptAt: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestUpdateAttemptAt())
        .map(value => zio.aws.translate.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.UpdateParallelDataResponse
  ): zio.aws.translate.model.UpdateParallelDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
