package zio.aws.translate
import zio.aws.translate.model.primitives.EncryptionKeyID.Type
import java.time.Instant
import zio.aws.translate.model.primitives.{ResourceName, LanguageCodeString}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object BoundedLengthString extends Subtype[String]
    type BoundedLengthString =
      zio.aws.translate.model.primitives.BoundedLengthString.Type
    object ClientTokenString extends Subtype[String]
    type ClientTokenString =
      zio.aws.translate.model.primitives.ClientTokenString.Type
    object ContentType extends Subtype[String]
    type ContentType = zio.aws.translate.model.primitives.ContentType.Type
    object Description extends Subtype[String]
    type Description = zio.aws.translate.model.primitives.Description.Type
    object EncryptionKeyID extends Subtype[String]
    type EncryptionKeyID =
      zio.aws.translate.model.primitives.EncryptionKeyID.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.translate.model.primitives.IamRoleArn.Type
    type Integer = Int
    object JobId extends Subtype[String]
    type JobId = zio.aws.translate.model.primitives.JobId.Type
    object JobName extends Subtype[String]
    type JobName = zio.aws.translate.model.primitives.JobName.Type
    object LanguageCodeString extends Subtype[String]
    type LanguageCodeString =
      zio.aws.translate.model.primitives.LanguageCodeString.Type
    object MaxResultsInteger extends Subtype[Int]
    type MaxResultsInteger =
      zio.aws.translate.model.primitives.MaxResultsInteger.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.translate.model.primitives.NextToken.Type
    object ParallelDataArn extends Subtype[String]
    type ParallelDataArn =
      zio.aws.translate.model.primitives.ParallelDataArn.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.translate.model.primitives.ResourceName.Type
    object S3Uri extends Subtype[String]
    type S3Uri = zio.aws.translate.model.primitives.S3Uri.Type
    object TerminologyArn extends Subtype[String]
    type TerminologyArn = zio.aws.translate.model.primitives.TerminologyArn.Type
    object TerminologyFile extends Subtype[Chunk[Byte]]
    type TerminologyFile =
      zio.aws.translate.model.primitives.TerminologyFile.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.translate.model.primitives.Timestamp.Type
    object UnboundedLengthString extends Subtype[String]
    type UnboundedLengthString =
      zio.aws.translate.model.primitives.UnboundedLengthString.Type
  }
  type AppliedTerminologyList = List[zio.aws.translate.model.AppliedTerminology]
  type LanguageCodeStringList = List[LanguageCodeString]
  type ParallelDataPropertiesList =
    List[zio.aws.translate.model.ParallelDataProperties]
  type ResourceNameList = List[ResourceName]
  type TargetLanguageCodeStringList = List[LanguageCodeString]
  type TermList = List[zio.aws.translate.model.Term]
  type TerminologyPropertiesList =
    List[zio.aws.translate.model.TerminologyProperties]
  type TextTranslationJobPropertiesList =
    List[zio.aws.translate.model.TextTranslationJobProperties]
}
