package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateByteMatchSetResponse(
    byteMatchSet: Option[zio.aws.waf.model.ByteMatchSet] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse = {
    import CreateByteMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
      .builder()
      .optionallyWith(byteMatchSet.map(value => value.buildAwsValue()))(
        _.byteMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateByteMatchSetResponse.ReadOnly =
    zio.aws.waf.model.CreateByteMatchSetResponse.wrap(buildAwsValue())
}
object CreateByteMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateByteMatchSetResponse =
      zio.aws.waf.model.CreateByteMatchSetResponse(
        byteMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def byteMatchSet: Option[zio.aws.waf.model.ByteMatchSet.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getByteMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.ByteMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("byteMatchSet", byteMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ) extends zio.aws.waf.model.CreateByteMatchSetResponse.ReadOnly {
    override val byteMatchSet: Option[zio.aws.waf.model.ByteMatchSet.ReadOnly] =
      scala
        .Option(impl.byteMatchSet())
        .map(value => zio.aws.waf.model.ByteMatchSet.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ): zio.aws.waf.model.CreateByteMatchSetResponse.ReadOnly = new Wrapper(impl)
}
