package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateRegexMatchSetResponse(
    regexMatchSet: Option[zio.aws.waf.model.RegexMatchSet] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse = {
    import CreateRegexMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse
      .builder()
      .optionallyWith(regexMatchSet.map(value => value.buildAwsValue()))(
        _.regexMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateRegexMatchSetResponse.ReadOnly =
    zio.aws.waf.model.CreateRegexMatchSetResponse.wrap(buildAwsValue())
}
object CreateRegexMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateRegexMatchSetResponse =
      zio.aws.waf.model.CreateRegexMatchSetResponse(
        regexMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def regexMatchSet: Option[zio.aws.waf.model.RegexMatchSet.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getRegexMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.RegexMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("regexMatchSet", regexMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse
  ) extends zio.aws.waf.model.CreateRegexMatchSetResponse.ReadOnly {
    override val regexMatchSet
        : Option[zio.aws.waf.model.RegexMatchSet.ReadOnly] = scala
      .Option(impl.regexMatchSet())
      .map(value => zio.aws.waf.model.RegexMatchSet.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse
  ): zio.aws.waf.model.CreateRegexMatchSetResponse.ReadOnly = new Wrapper(impl)
}
