package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateRuleGroupResponse(
    ruleGroup: Option[zio.aws.waf.model.RuleGroup] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse = {
    import CreateRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
      .builder()
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateRuleGroupResponse.ReadOnly =
    zio.aws.waf.model.CreateRuleGroupResponse.wrap(buildAwsValue())
}
object CreateRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateRuleGroupResponse =
      zio.aws.waf.model.CreateRuleGroupResponse(
        ruleGroup.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def ruleGroup: Option[zio.aws.waf.model.RuleGroup.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getRuleGroup: ZIO[Any, AwsError, zio.aws.waf.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ) extends zio.aws.waf.model.CreateRuleGroupResponse.ReadOnly {
    override val ruleGroup: Option[zio.aws.waf.model.RuleGroup.ReadOnly] = scala
      .Option(impl.ruleGroup())
      .map(value => zio.aws.waf.model.RuleGroup.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ): zio.aws.waf.model.CreateRuleGroupResponse.ReadOnly = new Wrapper(impl)
}
