package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateRuleResponse(
    rule: Option[zio.aws.waf.model.Rule] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRuleResponse = {
    import CreateRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRuleResponse
      .builder()
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateRuleResponse.ReadOnly =
    zio.aws.waf.model.CreateRuleResponse.wrap(buildAwsValue())
}
object CreateRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateRuleResponse =
      zio.aws.waf.model.CreateRuleResponse(
        rule.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def rule: Option[zio.aws.waf.model.Rule.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getRule: ZIO[Any, AwsError, zio.aws.waf.model.Rule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleResponse
  ) extends zio.aws.waf.model.CreateRuleResponse.ReadOnly {
    override val rule: Option[zio.aws.waf.model.Rule.ReadOnly] =
      scala.Option(impl.rule()).map(value => zio.aws.waf.model.Rule.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleResponse
  ): zio.aws.waf.model.CreateRuleResponse.ReadOnly = new Wrapper(impl)
}
