package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateSizeConstraintSetResponse(
    sizeConstraintSet: Option[zio.aws.waf.model.SizeConstraintSet] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse = {
    import CreateSizeConstraintSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse
      .builder()
      .optionallyWith(sizeConstraintSet.map(value => value.buildAwsValue()))(
        _.sizeConstraintSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateSizeConstraintSetResponse.ReadOnly =
    zio.aws.waf.model.CreateSizeConstraintSetResponse.wrap(buildAwsValue())
}
object CreateSizeConstraintSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateSizeConstraintSetResponse =
      zio.aws.waf.model.CreateSizeConstraintSetResponse(
        sizeConstraintSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def sizeConstraintSet: Option[zio.aws.waf.model.SizeConstraintSet.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getSizeConstraintSet
        : ZIO[Any, AwsError, zio.aws.waf.model.SizeConstraintSet.ReadOnly] =
      AwsError.unwrapOptionField("sizeConstraintSet", sizeConstraintSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse
  ) extends zio.aws.waf.model.CreateSizeConstraintSetResponse.ReadOnly {
    override val sizeConstraintSet
        : Option[zio.aws.waf.model.SizeConstraintSet.ReadOnly] = scala
      .Option(impl.sizeConstraintSet())
      .map(value => zio.aws.waf.model.SizeConstraintSet.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse
  ): zio.aws.waf.model.CreateSizeConstraintSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
