package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceName}
import scala.jdk.CollectionConverters._
final case class CreateXssMatchSetRequest(
    name: ResourceName,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateXssMatchSetRequest = {
    import CreateXssMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateXssMatchSetRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateXssMatchSetRequest.ReadOnly =
    zio.aws.waf.model.CreateXssMatchSetRequest.wrap(buildAwsValue())
}
object CreateXssMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateXssMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateXssMatchSetRequest =
      zio.aws.waf.model.CreateXssMatchSetRequest(name, changeToken)
    def name: ResourceName
    def changeToken: ChangeToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateXssMatchSetRequest
  ) extends zio.aws.waf.model.CreateXssMatchSetRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateXssMatchSetRequest
  ): zio.aws.waf.model.CreateXssMatchSetRequest.ReadOnly = new Wrapper(impl)
}
