package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class DeleteByteMatchSetResponse(
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteByteMatchSetResponse = {
    import DeleteByteMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteByteMatchSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteByteMatchSetResponse.ReadOnly =
    zio.aws.waf.model.DeleteByteMatchSetResponse.wrap(buildAwsValue())
}
object DeleteByteMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteByteMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteByteMatchSetResponse =
      zio.aws.waf.model
        .DeleteByteMatchSetResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteByteMatchSetResponse
  ) extends zio.aws.waf.model.DeleteByteMatchSetResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteByteMatchSetResponse
  ): zio.aws.waf.model.DeleteByteMatchSetResponse.ReadOnly = new Wrapper(impl)
}
