package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetByteMatchSetResponse(
    byteMatchSet: Option[zio.aws.waf.model.ByteMatchSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetByteMatchSetResponse = {
    import GetByteMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetByteMatchSetResponse
      .builder()
      .optionallyWith(byteMatchSet.map(value => value.buildAwsValue()))(
        _.byteMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetByteMatchSetResponse.ReadOnly =
    zio.aws.waf.model.GetByteMatchSetResponse.wrap(buildAwsValue())
}
object GetByteMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetByteMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetByteMatchSetResponse =
      zio.aws.waf.model
        .GetByteMatchSetResponse(byteMatchSet.map(value => value.asEditable))
    def byteMatchSet: Option[zio.aws.waf.model.ByteMatchSet.ReadOnly]
    def getByteMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.ByteMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("byteMatchSet", byteMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetByteMatchSetResponse
  ) extends zio.aws.waf.model.GetByteMatchSetResponse.ReadOnly {
    override val byteMatchSet: Option[zio.aws.waf.model.ByteMatchSet.ReadOnly] =
      scala
        .Option(impl.byteMatchSet())
        .map(value => zio.aws.waf.model.ByteMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetByteMatchSetResponse
  ): zio.aws.waf.model.GetByteMatchSetResponse.ReadOnly = new Wrapper(impl)
}
