package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetGeoMatchSetRequest(geoMatchSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest = {
    import GetGeoMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest
      .builder()
      .geoMatchSetId(ResourceId.unwrap(geoMatchSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetGeoMatchSetRequest.ReadOnly =
    zio.aws.waf.model.GetGeoMatchSetRequest.wrap(buildAwsValue())
}
object GetGeoMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetGeoMatchSetRequest =
      zio.aws.waf.model.GetGeoMatchSetRequest(geoMatchSetId)
    def geoMatchSetId: ResourceId
    def getGeoMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(geoMatchSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest
  ) extends zio.aws.waf.model.GetGeoMatchSetRequest.ReadOnly {
    override val geoMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.geoMatchSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest
  ): zio.aws.waf.model.GetGeoMatchSetRequest.ReadOnly = new Wrapper(impl)
}
