package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLoggingConfigurationResponse(
    loggingConfiguration: Option[zio.aws.waf.model.LoggingConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetLoggingConfigurationResponse = {
    import GetLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetLoggingConfigurationResponse.ReadOnly =
    zio.aws.waf.model.GetLoggingConfigurationResponse.wrap(buildAwsValue())
}
object GetLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetLoggingConfigurationResponse =
      zio.aws.waf.model.GetLoggingConfigurationResponse(
        loggingConfiguration.map(value => value.asEditable)
      )
    def loggingConfiguration
        : Option[zio.aws.waf.model.LoggingConfiguration.ReadOnly]
    def getLoggingConfiguration
        : ZIO[Any, AwsError, zio.aws.waf.model.LoggingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetLoggingConfigurationResponse
  ) extends zio.aws.waf.model.GetLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration
        : Option[zio.aws.waf.model.LoggingConfiguration.ReadOnly] = scala
      .Option(impl.loggingConfiguration())
      .map(value => zio.aws.waf.model.LoggingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetLoggingConfigurationResponse
  ): zio.aws.waf.model.GetLoggingConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
