package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.{NextMarker, ManagedKey}
import scala.jdk.CollectionConverters._
final case class GetRateBasedRuleManagedKeysResponse(
    managedKeys: Option[Iterable[ManagedKey]] = None,
    nextMarker: Option[NextMarker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysResponse = {
    import GetRateBasedRuleManagedKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysResponse
      .builder()
      .optionallyWith(
        managedKeys.map(value =>
          value.map { item =>
            ManagedKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.managedKeys)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.waf.model.GetRateBasedRuleManagedKeysResponse.ReadOnly =
    zio.aws.waf.model.GetRateBasedRuleManagedKeysResponse.wrap(buildAwsValue())
}
object GetRateBasedRuleManagedKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRateBasedRuleManagedKeysResponse =
      zio.aws.waf.model.GetRateBasedRuleManagedKeysResponse(
        managedKeys.map(value => value),
        nextMarker.map(value => value)
      )
    def managedKeys: Option[List[ManagedKey]]
    def nextMarker: Option[NextMarker]
    def getManagedKeys: ZIO[Any, AwsError, List[ManagedKey]] =
      AwsError.unwrapOptionField("managedKeys", managedKeys)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysResponse
  ) extends zio.aws.waf.model.GetRateBasedRuleManagedKeysResponse.ReadOnly {
    override val managedKeys: Option[List[ManagedKey]] = scala
      .Option(impl.managedKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.waf.model.primitives.ManagedKey(item)
        }.toList
      )
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysResponse
  ): zio.aws.waf.model.GetRateBasedRuleManagedKeysResponse.ReadOnly =
    new Wrapper(impl)
}
