package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetRegexPatternSetRequest(regexPatternSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest = {
    import GetRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest
      .builder()
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetRegexPatternSetRequest.ReadOnly =
    zio.aws.waf.model.GetRegexPatternSetRequest.wrap(buildAwsValue())
}
object GetRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRegexPatternSetRequest =
      zio.aws.waf.model.GetRegexPatternSetRequest(regexPatternSetId)
    def regexPatternSetId: ResourceId
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest
  ) extends zio.aws.waf.model.GetRegexPatternSetRequest.ReadOnly {
    override val regexPatternSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.regexPatternSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest
  ): zio.aws.waf.model.GetRegexPatternSetRequest.ReadOnly = new Wrapper(impl)
}
