package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetWebAclResponse(
    webACL: Option[zio.aws.waf.model.WebACL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetWebAclResponse = {
    import GetWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetWebAclResponse
      .builder()
      .optionallyWith(webACL.map(value => value.buildAwsValue()))(_.webACL)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetWebAclResponse.ReadOnly =
    zio.aws.waf.model.GetWebAclResponse.wrap(buildAwsValue())
}
object GetWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetWebAclResponse =
      zio.aws.waf.model.GetWebAclResponse(webACL.map(value => value.asEditable))
    def webACL: Option[zio.aws.waf.model.WebACL.ReadOnly]
    def getWebACL: ZIO[Any, AwsError, zio.aws.waf.model.WebACL.ReadOnly] =
      AwsError.unwrapOptionField("webACL", webACL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclResponse
  ) extends zio.aws.waf.model.GetWebAclResponse.ReadOnly {
    override val webACL: Option[zio.aws.waf.model.WebACL.ReadOnly] = scala
      .Option(impl.webACL())
      .map(value => zio.aws.waf.model.WebACL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclResponse
  ): zio.aws.waf.model.GetWebAclResponse.ReadOnly = new Wrapper(impl)
}
