package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetXssMatchSetResponse(
    xssMatchSet: Option[zio.aws.waf.model.XssMatchSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse = {
    import GetXssMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
      .builder()
      .optionallyWith(xssMatchSet.map(value => value.buildAwsValue()))(
        _.xssMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetXssMatchSetResponse.ReadOnly =
    zio.aws.waf.model.GetXssMatchSetResponse.wrap(buildAwsValue())
}
object GetXssMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetXssMatchSetResponse = zio.aws.waf.model
      .GetXssMatchSetResponse(xssMatchSet.map(value => value.asEditable))
    def xssMatchSet: Option[zio.aws.waf.model.XssMatchSet.ReadOnly]
    def getXssMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.XssMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("xssMatchSet", xssMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ) extends zio.aws.waf.model.GetXssMatchSetResponse.ReadOnly {
    override val xssMatchSet: Option[zio.aws.waf.model.XssMatchSet.ReadOnly] =
      scala
        .Option(impl.xssMatchSet())
        .map(value => zio.aws.waf.model.XssMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ): zio.aws.waf.model.GetXssMatchSetResponse.ReadOnly = new Wrapper(impl)
}
