package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.{HeaderValue, HeaderName}
import scala.jdk.CollectionConverters._
final case class HTTPHeader(
    name: Option[HeaderName] = None,
    value: Option[HeaderValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.HTTPHeader = {
    import HTTPHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.HTTPHeader
      .builder()
      .optionallyWith(
        name.map(value => HeaderName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => HeaderValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.HTTPHeader.ReadOnly =
    zio.aws.waf.model.HTTPHeader.wrap(buildAwsValue())
}
object HTTPHeader {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.HTTPHeader] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.HTTPHeader = zio.aws.waf.model
      .HTTPHeader(name.map(value => value), value.map(value => value))
    def name: Option[HeaderName]
    def value: Option[HeaderValue]
    def getName: ZIO[Any, AwsError, HeaderName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, HeaderValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.HTTPHeader
  ) extends zio.aws.waf.model.HTTPHeader.ReadOnly {
    override val name: Option[HeaderName] = scala
      .Option(impl.name())
      .map(value => zio.aws.waf.model.primitives.HeaderName(value))
    override val value: Option[HeaderValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.waf.model.primitives.HeaderValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.HTTPHeader
  ): zio.aws.waf.model.HTTPHeader.ReadOnly = new Wrapper(impl)
}
