package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.{
  IPString,
  HTTPVersion,
  HTTPMethod,
  URIString,
  Country
}
import scala.jdk.CollectionConverters._
final case class HTTPRequest(
    clientIP: Option[IPString] = None,
    country: Option[Country] = None,
    uri: Option[URIString] = None,
    method: Option[HTTPMethod] = None,
    httpVersion: Option[HTTPVersion] = None,
    headers: Option[Iterable[zio.aws.waf.model.HTTPHeader]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.HTTPRequest = {
    import HTTPRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.HTTPRequest
      .builder()
      .optionallyWith(
        clientIP.map(value => IPString.unwrap(value): java.lang.String)
      )(_.clientIP)
      .optionallyWith(
        country.map(value => Country.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(
        uri.map(value => URIString.unwrap(value): java.lang.String)
      )(_.uri)
      .optionallyWith(
        method.map(value => HTTPMethod.unwrap(value): java.lang.String)
      )(_.method)
      .optionallyWith(
        httpVersion.map(value => HTTPVersion.unwrap(value): java.lang.String)
      )(_.httpVersion)
      .optionallyWith(
        headers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.headers)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.HTTPRequest.ReadOnly =
    zio.aws.waf.model.HTTPRequest.wrap(buildAwsValue())
}
object HTTPRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.HTTPRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.HTTPRequest =
      zio.aws.waf.model.HTTPRequest(
        clientIP.map(value => value),
        country.map(value => value),
        uri.map(value => value),
        method.map(value => value),
        httpVersion.map(value => value),
        headers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientIP: Option[IPString]
    def country: Option[Country]
    def uri: Option[URIString]
    def method: Option[HTTPMethod]
    def httpVersion: Option[HTTPVersion]
    def headers: Option[List[zio.aws.waf.model.HTTPHeader.ReadOnly]]
    def getClientIP: ZIO[Any, AwsError, IPString] =
      AwsError.unwrapOptionField("clientIP", clientIP)
    def getCountry: ZIO[Any, AwsError, Country] =
      AwsError.unwrapOptionField("country", country)
    def getUri: ZIO[Any, AwsError, URIString] =
      AwsError.unwrapOptionField("uri", uri)
    def getMethod: ZIO[Any, AwsError, HTTPMethod] =
      AwsError.unwrapOptionField("method", method)
    def getHttpVersion: ZIO[Any, AwsError, HTTPVersion] =
      AwsError.unwrapOptionField("httpVersion", httpVersion)
    def getHeaders
        : ZIO[Any, AwsError, List[zio.aws.waf.model.HTTPHeader.ReadOnly]] =
      AwsError.unwrapOptionField("headers", headers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.HTTPRequest
  ) extends zio.aws.waf.model.HTTPRequest.ReadOnly {
    override val clientIP: Option[IPString] = scala
      .Option(impl.clientIP())
      .map(value => zio.aws.waf.model.primitives.IPString(value))
    override val country: Option[Country] = scala
      .Option(impl.country())
      .map(value => zio.aws.waf.model.primitives.Country(value))
    override val uri: Option[URIString] = scala
      .Option(impl.uri())
      .map(value => zio.aws.waf.model.primitives.URIString(value))
    override val method: Option[HTTPMethod] = scala
      .Option(impl.method())
      .map(value => zio.aws.waf.model.primitives.HTTPMethod(value))
    override val httpVersion: Option[HTTPVersion] = scala
      .Option(impl.httpVersion())
      .map(value => zio.aws.waf.model.primitives.HTTPVersion(value))
    override val headers: Option[List[zio.aws.waf.model.HTTPHeader.ReadOnly]] =
      scala
        .Option(impl.headers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.HTTPHeader.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.HTTPRequest
  ): zio.aws.waf.model.HTTPRequest.ReadOnly = new Wrapper(impl)
}
