package zio.aws.waf.model
import scala.jdk.CollectionConverters._
sealed trait IPSetDescriptorType {
  def unwrap: software.amazon.awssdk.services.waf.model.IPSetDescriptorType
}
object IPSetDescriptorType {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.IPSetDescriptorType
  ): zio.aws.waf.model.IPSetDescriptorType = value match {
    case software.amazon.awssdk.services.waf.model.IPSetDescriptorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.IPSetDescriptorType.IPV4 =>
      val r = IPV4
      r
    case software.amazon.awssdk.services.waf.model.IPSetDescriptorType.IPV6 =>
      val r = IPV6
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.waf.model.IPSetDescriptorType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.IPSetDescriptorType =
      software.amazon.awssdk.services.waf.model.IPSetDescriptorType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPV4 extends zio.aws.waf.model.IPSetDescriptorType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.IPSetDescriptorType =
      software.amazon.awssdk.services.waf.model.IPSetDescriptorType.IPV4
  }
  case object IPV6 extends zio.aws.waf.model.IPSetDescriptorType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.IPSetDescriptorType =
      software.amazon.awssdk.services.waf.model.IPSetDescriptorType.IPV6
  }
}
