package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListActivatedRulesInRuleGroupResponse(
    nextMarker: Option[NextMarker] = None,
    activatedRules: Option[Iterable[zio.aws.waf.model.ActivatedRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse = {
    import ListActivatedRulesInRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        activatedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activatedRules)
      .build()
  }
  def asReadOnly
      : zio.aws.waf.model.ListActivatedRulesInRuleGroupResponse.ReadOnly =
    zio.aws.waf.model.ListActivatedRulesInRuleGroupResponse
      .wrap(buildAwsValue())
}
object ListActivatedRulesInRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListActivatedRulesInRuleGroupResponse =
      zio.aws.waf.model.ListActivatedRulesInRuleGroupResponse(
        nextMarker.map(value => value),
        activatedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def activatedRules: Option[List[zio.aws.waf.model.ActivatedRule.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getActivatedRules
        : ZIO[Any, AwsError, List[zio.aws.waf.model.ActivatedRule.ReadOnly]] =
      AwsError.unwrapOptionField("activatedRules", activatedRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse
  ) extends zio.aws.waf.model.ListActivatedRulesInRuleGroupResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val activatedRules
        : Option[List[zio.aws.waf.model.ActivatedRule.ReadOnly]] = scala
      .Option(impl.activatedRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.waf.model.ActivatedRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse
  ): zio.aws.waf.model.ListActivatedRulesInRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
