package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListRegexPatternSetsResponse(
    nextMarker: Option[NextMarker] = None,
    regexPatternSets: Option[
      Iterable[zio.aws.waf.model.RegexPatternSetSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse = {
    import ListRegexPatternSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        regexPatternSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regexPatternSets)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListRegexPatternSetsResponse.ReadOnly =
    zio.aws.waf.model.ListRegexPatternSetsResponse.wrap(buildAwsValue())
}
object ListRegexPatternSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListRegexPatternSetsResponse =
      zio.aws.waf.model.ListRegexPatternSetsResponse(
        nextMarker.map(value => value),
        regexPatternSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def regexPatternSets
        : Option[List[zio.aws.waf.model.RegexPatternSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRegexPatternSets: ZIO[Any, AwsError, List[
      zio.aws.waf.model.RegexPatternSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("regexPatternSets", regexPatternSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ) extends zio.aws.waf.model.ListRegexPatternSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val regexPatternSets
        : Option[List[zio.aws.waf.model.RegexPatternSetSummary.ReadOnly]] =
      scala
        .Option(impl.regexPatternSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.RegexPatternSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ): zio.aws.waf.model.ListRegexPatternSetsResponse.ReadOnly = new Wrapper(impl)
}
