package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListRuleGroupsResponse(
    nextMarker: Option[NextMarker] = None,
    ruleGroups: Option[Iterable[zio.aws.waf.model.RuleGroupSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse = {
    import ListRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        ruleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleGroups)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListRuleGroupsResponse.ReadOnly =
    zio.aws.waf.model.ListRuleGroupsResponse.wrap(buildAwsValue())
}
object ListRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListRuleGroupsResponse =
      zio.aws.waf.model.ListRuleGroupsResponse(
        nextMarker.map(value => value),
        ruleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def ruleGroups: Option[List[zio.aws.waf.model.RuleGroupSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.waf.model.RuleGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleGroups", ruleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse
  ) extends zio.aws.waf.model.ListRuleGroupsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val ruleGroups
        : Option[List[zio.aws.waf.model.RuleGroupSummary.ReadOnly]] = scala
      .Option(impl.ruleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.waf.model.RuleGroupSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse
  ): zio.aws.waf.model.ListRuleGroupsResponse.ReadOnly = new Wrapper(impl)
}
