package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListRulesResponse(
    nextMarker: Option[NextMarker] = None,
    rules: Option[Iterable[zio.aws.waf.model.RuleSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRulesResponse = {
    import ListRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRulesResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListRulesResponse.ReadOnly =
    zio.aws.waf.model.ListRulesResponse.wrap(buildAwsValue())
}
object ListRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListRulesResponse =
      zio.aws.waf.model.ListRulesResponse(
        nextMarker.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def rules: Option[List[zio.aws.waf.model.RuleSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.waf.model.RuleSummary.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRulesResponse
  ) extends zio.aws.waf.model.ListRulesResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val rules: Option[List[zio.aws.waf.model.RuleSummary.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.RuleSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRulesResponse
  ): zio.aws.waf.model.ListRulesResponse.ReadOnly = new Wrapper(impl)
}
