package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListSqlInjectionMatchSetsResponse(
    nextMarker: Option[NextMarker] = None,
    sqlInjectionMatchSets: Option[
      Iterable[zio.aws.waf.model.SqlInjectionMatchSetSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse = {
    import ListSqlInjectionMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        sqlInjectionMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sqlInjectionMatchSets)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListSqlInjectionMatchSetsResponse.ReadOnly =
    zio.aws.waf.model.ListSqlInjectionMatchSetsResponse.wrap(buildAwsValue())
}
object ListSqlInjectionMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListSqlInjectionMatchSetsResponse =
      zio.aws.waf.model.ListSqlInjectionMatchSetsResponse(
        nextMarker.map(value => value),
        sqlInjectionMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def sqlInjectionMatchSets
        : Option[List[zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getSqlInjectionMatchSets: ZIO[Any, AwsError, List[
      zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("sqlInjectionMatchSets", sqlInjectionMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ) extends zio.aws.waf.model.ListSqlInjectionMatchSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val sqlInjectionMatchSets
        : Option[List[zio.aws.waf.model.SqlInjectionMatchSetSummary.ReadOnly]] =
      scala
        .Option(impl.sqlInjectionMatchSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.SqlInjectionMatchSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListSqlInjectionMatchSetsResponse
  ): zio.aws.waf.model.ListSqlInjectionMatchSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
