package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.{
  RateLimit,
  MetricName,
  ResourceName,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class RateBasedRule(
    ruleId: ResourceId,
    name: Option[ResourceName] = None,
    metricName: Option[MetricName] = None,
    matchPredicates: Iterable[zio.aws.waf.model.Predicate],
    rateKey: zio.aws.waf.model.RateKey,
    rateLimit: RateLimit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RateBasedRule = {
    import RateBasedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RateBasedRule
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .matchPredicates(matchPredicates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .rateKey(rateKey.unwrap)
      .rateLimit(RateLimit.unwrap(rateLimit): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RateBasedRule.ReadOnly =
    zio.aws.waf.model.RateBasedRule.wrap(buildAwsValue())
}
object RateBasedRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.RateBasedRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RateBasedRule =
      zio.aws.waf.model.RateBasedRule(
        ruleId,
        name.map(value => value),
        metricName.map(value => value),
        matchPredicates.map { item =>
          item.asEditable
        },
        rateKey,
        rateLimit
      )
    def ruleId: ResourceId
    def name: Option[ResourceName]
    def metricName: Option[MetricName]
    def matchPredicates: List[zio.aws.waf.model.Predicate.ReadOnly]
    def rateKey: zio.aws.waf.model.RateKey
    def rateLimit: RateLimit
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMatchPredicates
        : ZIO[Any, Nothing, List[zio.aws.waf.model.Predicate.ReadOnly]] =
      ZIO.succeed(matchPredicates)
    def getRateKey: ZIO[Any, Nothing, zio.aws.waf.model.RateKey] =
      ZIO.succeed(rateKey)
    def getRateLimit: ZIO[Any, Nothing, RateLimit] = ZIO.succeed(rateLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RateBasedRule
  ) extends zio.aws.waf.model.RateBasedRule.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.waf.model.primitives.MetricName(value))
    override val matchPredicates: List[zio.aws.waf.model.Predicate.ReadOnly] =
      impl
        .matchPredicates()
        .asScala
        .map { item =>
          zio.aws.waf.model.Predicate.wrap(item)
        }
        .toList
    override val rateKey: zio.aws.waf.model.RateKey =
      zio.aws.waf.model.RateKey.wrap(impl.rateKey())
    override val rateLimit: RateLimit =
      zio.aws.waf.model.primitives.RateLimit(impl.rateLimit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RateBasedRule
  ): zio.aws.waf.model.RateBasedRule.ReadOnly = new Wrapper(impl)
}
