package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class RuleSummary(ruleId: ResourceId, name: ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.RuleSummary = {
    import RuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RuleSummary
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RuleSummary.ReadOnly =
    zio.aws.waf.model.RuleSummary.wrap(buildAwsValue())
}
object RuleSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.RuleSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RuleSummary =
      zio.aws.waf.model.RuleSummary(ruleId, name)
    def ruleId: ResourceId
    def name: ResourceName
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RuleSummary
  ) extends zio.aws.waf.model.RuleSummary.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RuleSummary
  ): zio.aws.waf.model.RuleSummary.ReadOnly = new Wrapper(impl)
}
