package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.Size
import scala.jdk.CollectionConverters._
final case class SizeConstraint(
    fieldToMatch: zio.aws.waf.model.FieldToMatch,
    textTransformation: zio.aws.waf.model.TextTransformation,
    comparisonOperator: zio.aws.waf.model.ComparisonOperator,
    size: Size
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SizeConstraint = {
    import SizeConstraint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SizeConstraint
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformation(textTransformation.unwrap)
      .comparisonOperator(comparisonOperator.unwrap)
      .size(Size.unwrap(size): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SizeConstraint.ReadOnly =
    zio.aws.waf.model.SizeConstraint.wrap(buildAwsValue())
}
object SizeConstraint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SizeConstraint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SizeConstraint =
      zio.aws.waf.model.SizeConstraint(
        fieldToMatch.asEditable,
        textTransformation,
        comparisonOperator,
        size
      )
    def fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly
    def textTransformation: zio.aws.waf.model.TextTransformation
    def comparisonOperator: zio.aws.waf.model.ComparisonOperator
    def size: Size
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.waf.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.waf.model.TextTransformation] =
      ZIO.succeed(textTransformation)
    def getComparisonOperator
        : ZIO[Any, Nothing, zio.aws.waf.model.ComparisonOperator] =
      ZIO.succeed(comparisonOperator)
    def getSize: ZIO[Any, Nothing, Size] = ZIO.succeed(size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraint
  ) extends zio.aws.waf.model.SizeConstraint.ReadOnly {
    override val fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly =
      zio.aws.waf.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformation: zio.aws.waf.model.TextTransformation =
      zio.aws.waf.model.TextTransformation.wrap(impl.textTransformation())
    override val comparisonOperator: zio.aws.waf.model.ComparisonOperator =
      zio.aws.waf.model.ComparisonOperator.wrap(impl.comparisonOperator())
    override val size: Size = zio.aws.waf.model.primitives.Size(impl.size())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraint
  ): zio.aws.waf.model.SizeConstraint.ReadOnly = new Wrapper(impl)
}
