package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateRegexMatchSetRequest(
    regexMatchSetId: ResourceId,
    updates: Iterable[zio.aws.waf.model.RegexMatchSetUpdate],
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest = {
    import UpdateRegexMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest
      .builder()
      .regexMatchSetId(ResourceId.unwrap(regexMatchSetId): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateRegexMatchSetRequest.ReadOnly =
    zio.aws.waf.model.UpdateRegexMatchSetRequest.wrap(buildAwsValue())
}
object UpdateRegexMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateRegexMatchSetRequest =
      zio.aws.waf.model.UpdateRegexMatchSetRequest(
        regexMatchSetId,
        updates.map { item =>
          item.asEditable
        },
        changeToken
      )
    def regexMatchSetId: ResourceId
    def updates: List[zio.aws.waf.model.RegexMatchSetUpdate.ReadOnly]
    def changeToken: ChangeToken
    def getRegexMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexMatchSetId)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.waf.model.RegexMatchSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest
  ) extends zio.aws.waf.model.UpdateRegexMatchSetRequest.ReadOnly {
    override val regexMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.regexMatchSetId())
    override val updates: List[zio.aws.waf.model.RegexMatchSetUpdate.ReadOnly] =
      impl
        .updates()
        .asScala
        .map { item =>
          zio.aws.waf.model.RegexMatchSetUpdate.wrap(item)
        }
        .toList
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest
  ): zio.aws.waf.model.UpdateRegexMatchSetRequest.ReadOnly = new Wrapper(impl)
}
