package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateRuleGroupRequest(
    ruleGroupId: ResourceId,
    updates: Iterable[zio.aws.waf.model.RuleGroupUpdate],
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest = {
    import UpdateRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest
      .builder()
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateRuleGroupRequest.ReadOnly =
    zio.aws.waf.model.UpdateRuleGroupRequest.wrap(buildAwsValue())
}
object UpdateRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateRuleGroupRequest =
      zio.aws.waf.model.UpdateRuleGroupRequest(
        ruleGroupId,
        updates.map { item =>
          item.asEditable
        },
        changeToken
      )
    def ruleGroupId: ResourceId
    def updates: List[zio.aws.waf.model.RuleGroupUpdate.ReadOnly]
    def changeToken: ChangeToken
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
    def getUpdates
        : ZIO[Any, Nothing, List[zio.aws.waf.model.RuleGroupUpdate.ReadOnly]] =
      ZIO.succeed(updates)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest
  ) extends zio.aws.waf.model.UpdateRuleGroupRequest.ReadOnly {
    override val ruleGroupId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleGroupId())
    override val updates: List[zio.aws.waf.model.RuleGroupUpdate.ReadOnly] =
      impl
        .updates()
        .asScala
        .map { item =>
          zio.aws.waf.model.RuleGroupUpdate.wrap(item)
        }
        .toList
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest
  ): zio.aws.waf.model.UpdateRuleGroupRequest.ReadOnly = new Wrapper(impl)
}
