package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class UpdateSizeConstraintSetResponse(
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetResponse = {
    import UpdateSizeConstraintSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateSizeConstraintSetResponse.ReadOnly =
    zio.aws.waf.model.UpdateSizeConstraintSetResponse.wrap(buildAwsValue())
}
object UpdateSizeConstraintSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateSizeConstraintSetResponse =
      zio.aws.waf.model
        .UpdateSizeConstraintSetResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetResponse
  ) extends zio.aws.waf.model.UpdateSizeConstraintSetResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetResponse
  ): zio.aws.waf.model.UpdateSizeConstraintSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
