package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateSqlInjectionMatchSetRequest(
    sqlInjectionMatchSetId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.waf.model.SqlInjectionMatchSetUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest = {
    import UpdateSqlInjectionMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest
      .builder()
      .sqlInjectionMatchSetId(
        ResourceId.unwrap(sqlInjectionMatchSetId): java.lang.String
      )
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateSqlInjectionMatchSetRequest.ReadOnly =
    zio.aws.waf.model.UpdateSqlInjectionMatchSetRequest.wrap(buildAwsValue())
}
object UpdateSqlInjectionMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateSqlInjectionMatchSetRequest =
      zio.aws.waf.model.UpdateSqlInjectionMatchSetRequest(
        sqlInjectionMatchSetId,
        changeToken,
        updates.map { item =>
          item.asEditable
        }
      )
    def sqlInjectionMatchSetId: ResourceId
    def changeToken: ChangeToken
    def updates: List[zio.aws.waf.model.SqlInjectionMatchSetUpdate.ReadOnly]
    def getSqlInjectionMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sqlInjectionMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.waf.model.SqlInjectionMatchSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest
  ) extends zio.aws.waf.model.UpdateSqlInjectionMatchSetRequest.ReadOnly {
    override val sqlInjectionMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sqlInjectionMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val updates
        : List[zio.aws.waf.model.SqlInjectionMatchSetUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.waf.model.SqlInjectionMatchSetUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest
  ): zio.aws.waf.model.UpdateSqlInjectionMatchSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
