package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class UpdateSqlInjectionMatchSetResponse(
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse = {
    import UpdateSqlInjectionMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.waf.model.UpdateSqlInjectionMatchSetResponse.ReadOnly =
    zio.aws.waf.model.UpdateSqlInjectionMatchSetResponse.wrap(buildAwsValue())
}
object UpdateSqlInjectionMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateSqlInjectionMatchSetResponse =
      zio.aws.waf.model
        .UpdateSqlInjectionMatchSetResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse
  ) extends zio.aws.waf.model.UpdateSqlInjectionMatchSetResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse
  ): zio.aws.waf.model.UpdateSqlInjectionMatchSetResponse.ReadOnly =
    new Wrapper(impl)
}
